<?php

namespace App\Http\Controllers\Nami\Command;

use App\Services\Nami\CommandTerminalService as objService;
use Illuminate\Http\Request;
use Symfony\Component\Process\Process;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Artisan;

class TerminalController extends Controller
{

    public string $folderPath = "nami.terminal";

    public function index() {
        $data["bladeTitle"] = __("auth.Server Terminal");
        return view($this->folderPath . '.terminal', $data);
    }

    public function store(Request $request)
    {
        $command = $request->input('command');
        if (strpos($command, 'php artisan') !== false) {
            // Extract the Artisan command without 'php artisan'
            $artisanCommand = str_replace('php artisan ', '', $command);

            // Call the Artisan command
            Artisan::call($artisanCommand);
            $output = Artisan::output();

            return response()->json(['output' => $output]);
        } else {
            // Execute non-Artisan commands using Process
            $process = Process::fromShellCommandline($command, base_path());
            $process->setTimeout(3600); // Set timeout to 1 hour if needed
            $process->run();

            if (!$process->isSuccessful()) {
                return response()->json(['output' => 'Command failed: ' . $process->getErrorOutput()], 500);
            }

            $output = $process->getOutput();

            return response()->json(['output' => $output]);
        }
    }


    // public function executeCommand(Request $request)
    // {
    //     $command = $request->input('command');

    //     // Only allow certain commands for security reasons
    //     $allowedCommands = ['ls', 'pwd', 'whoami', 'df', 'free', 'uptime'];
    //     $explodedCommand = explode(' ', $command);
    //     if (!in_array($explodedCommand[0], $allowedCommands)) {
    //         return response()->json(['output' => 'Command not allowed'], 403);
    //     }

    //     $process = new Process(explode(' ', $command));
    //     $process->run();

    //     if (!$process->isSuccessful()) {
    //         throw new ProcessFailedException($process);
    //     }

    //     $output = $process->getOutput();

    //     $pusher = new Pusher(
    //         env('PUSHER_APP_KEY'),
    //         env('PUSHER_APP_SECRET'),
    //         env('PUSHER_APP_ID'),
    //         [
    //             'cluster' => env('PUSHER_APP_CLUSTER'),
    //             'useTLS' => true
    //         ]
    //     );

    //     $pusher->trigger('terminal-channel', 'new-output', ['output' => $output]);

    //     return response()->json(['output' => $output]);
    // }
}
